#### Objective
- Transfer mail reliably and efficiently between users.
- Operates independently of the transmission subsystem, requiring only a reliable ordered data stream channel.
- Primarily uses TCP as the transport protocol.

#### Client/Server Communication
- Involves exchanging commands and reply codes.
- Email messages include headers with sender, recipient, and additional information.
- Relies heavily on DNS records to identify destination mail servers.

### SMTP Operation
###### Communication Protocol
- Text-based protocol for email transport between clients and servers.
- Most commonly uses TCP, initiating connections on port 25.

###### Client and Server Roles
- Client sends email; server receives it.
- SMTP sessions involve exchanges of commands from the client and reply codes from the server.

###### Transmission Process
1. **Initiate TCP Connection**: Client connects to server on port 25.
2. **Exchange Commands**: Client sends commands; server replies with codes.
3. **Transmit Email**: Includes headers and text formatted per RFC 822.
4. **Session Termination**: Concludes with a QUIT command.

###### Reply Codes
- **2xx**: Success
- **3xx**: Redirection
- **4xx**: Temporary failure
- **5xx**: Permanent failure

### SMTP Conversation Stages

###### Stages
1. **Envelope Headers**: Includes MAIL FROM and RCPT TO addresses.
2. **Session Tasks**: Initiating session, identifying sender and recipient, sending content.
3. **Multiple Recipients**: Utilizes RCPT TO for bandwidth efficiency.

###### Fully Qualified Domain Names (FQDN)
- Required for client-hostname, sender, and recipient addresses.
- Provides internet-wide lookup capability.

### DNS and SMTP
###### DNS Role
- **MX Records**: Points to mail servers receiving emails.
- **A Records**: Maps FQDN to IP addresses.
###### MTA Functionality
- Transfers emails between computers via software agents.
- Cisco Secure Email acts as an MTA, handling receiving and sending emails.

### Email Delivery Process
###### Stages
1. **MTA Receives Email**: From sender (e.g., [user1@secure-x.public](mailto:user1@secure-x.public)).
2. **DNS Lookup**: Finds destination mail server's IP using MX and A records.
3. **Session Initiation**: SMTP client addresses and forwards packet to server.
4. **Domain Reputation Check**: Server verifies sender's domain reputation.
5. **Forward to Local Server**: Using protocols like POP, IMAP, and MAPI.

###### SMTP Conversation Parts

1. **Envelope Exchange**: Identifies sender and recipient.
2. **Content Headers**: Sent after 354-status code; includes sender/recipient info, subject, and date.
3. **Message Body**: Follows headers; ends with a period (.) indicating end of transmission.

### Cisco Secure Email Gateway High Availability

###### Resiliency and Redundancy
- Achieved by deploying multiple gateways with DNS records.
- **MX and A Records**: Direct traffic based on priority to primary or backup gateways.

###### Centralized Management
- Allows sharing of configurations across multiple appliances.
- Supports global management while complying with local policies.

###### Configuration Hierarchy

- **Machine Level**: Overrides group and cluster levels.
- **Group Level**: Overrides cluster level.
- **Cluster Level**: Applies to all appliances in the cluster.
###### Example
- Disabling antivirus at the machine level overrides group and cluster configurations.